<?
	require_once("incl/config.php");
	require_once(GLOBAL_INCLUDE_PATH."incl/startup.php");
	
	function clean_special_chars($string) {
    // Step 1: Convert to UTF-8 encoding (if not already)
    $string = mb_convert_encoding($string, 'UTF-8', 'auto');

    // Step 2: Remove characters that are not standard ASCII (letters, numbers, common punctuation)
    $string = preg_replace('/[^\x20-\x7E]/', '', $string);

    // Step 3: Optionally trim extra spaces
    $string = trim($string);

        return $string;
    }
	
	$isoLastModifiedSite = "";
	$newLine = "\n";
	$indent = " ";
	if (!$rootUrl) $rootUrl = "https://".strtolower(SITE_DOMAIN);

	$xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>$newLine";


	$urlsetOpen = "<urlset xmlns=\"http://www.google.com/schemas/sitemap/0.84\" 
	xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" 
	xsi:schemaLocation=\"http://www.google.com/schemas/sitemap/0.84 
	http://www.google.com/schemas/sitemap/0.84/sitemap.xsd\">$newLine";
	
	$urlsetValue = "";
	$urlsetClose = "</urlset>$newLine";

function makeUrlString ($urlString) {
    return htmlentities($urlString, ENT_QUOTES, 'UTF-8'); 
}

function makeIso8601TimeStamp ($dateTime) {
    if (!$dateTime) {
        $dateTime = date('Y-m-d H:i:s');
    }
    if (is_numeric(substr($dateTime, 11, 1))) {
        $isoTS = substr($dateTime, 0, 10) ."T" 
                 .substr($dateTime, 11, 8) ."+00:00";
    }
    else {
        $isoTS = substr($dateTime, 0, 10);
    }
    return $isoTS;
}

function makeUrlTag ($url, $modifiedDateTime, $changeFrequency, $priority) {
    GLOBAL $newLine;
    GLOBAL $indent;
    GLOBAL $isoLastModifiedSite;
    $urlOpen = "$indent<url>$newLine";
    $urlValue = "";
    $urlClose = "$indent</url>$newLine";
    $locOpen = "$indent$indent<loc>";
    $locValue = "";
    $locClose = "</loc>$newLine";
    $lastmodOpen = "$indent$indent<lastmod>";
    $lastmodValue = "";
    $lastmodClose = "</lastmod>$newLine";
    $changefreqOpen = "$indent$indent<changefreq>";
    $changefreqValue = "";
    $changefreqClose = "</changefreq>$newLine";
    $priorityOpen = "$indent$indent<priority>";
    $priorityValue = "";
    $priorityClose = "</priority>$newLine";

    $urlTag = $urlOpen;
	
	$urlValue     = $locOpen .makeUrlString("$url") .$locClose;
	
	if ($modifiedDateTime) {
	 $urlValue .= $lastmodOpen .makeIso8601TimeStamp($modifiedDateTime) .$lastmodClose; 
	 if (!$isoLastModifiedSite) { // last modification of web site
		 $isoLastModifiedSite = makeIso8601TimeStamp($modifiedDateTime); 
	 } 
	}
	if ($changeFrequency) {
	 $urlValue .= $changefreqOpen .$changeFrequency .$changefreqClose; 
	}
	if ($priority) {
	 $urlValue .= $priorityOpen .$priority .$priorityClose; 
	}
	$urlTag .= $urlValue;
	$urlTag .= $urlClose;
	return $urlTag;
}
	
    // Connecting to the Database 
	//$connect = @mysql_connect(DB_HOST, DB_USER, DB_PASS) or die("could not connect to server"); 

	// Selecting the Database for use 
	//$db_select = @mysql_select_db(DB_NAME) or die("could not select the database"); 
	
	require_once(GLOBAL_INCLUDE_PATH."incl/dbopenconn.php");
	$QryUser        = mysqli_query($connect,"select CompanyProdID,producttitle,ProductName,productimagefilepath,CompanyName,c.CompanyID from trncompanyprod a inner join mstcompany c on a.companyid=c.companyid inner join mstproduct b on a.productid=b.productid where productimagefilepath !='' and EliteConfirmed =1 limit 0,49998");
	
	//comprods/'.$companyprodid.'/'.$producttitleurl
	
	if($QryUser)
	{
		//$urlsetValue .= makeUrlTag ($pageUrl, $isoLastModifiedSite, "daily", "1.0");
		
		while($rsUser = mysqli_fetch_row($QryUser))
		{
		
			$CompanyName     = replaceForURL(clean_special_chars($rsUser[4]));
			$CompanyID       = replaceForURL($rsUser[5]);
			$producttitleurl = replaceForURL(clean_special_chars($rsUser[1])).'.html';
			
			$producttitleurl =	str_replace("",'',$producttitleurl);
			$producttitleurl =	str_replace("",'',$producttitleurl);
			$producttitleurl = htmlentities($producttitleurl);
			$producttitleurl = strtolower($producttitleurl);
			
			//$producttitleurl =str_replace("(",'',$producttitleurl); 
			//$producttitleurl =str_replace(")",'',$producttitleurl);
			// https://gulfyp.com/co-shenzhen-aunont-electronics-co,-ltd/1374294/products/1776769/ultra_and_-thin-power-supply-ip67-wa_and_-12v_and_-100w.html
			if (($rsUser[0]!='')&& ($producttitleurl!='')){
				$pageUrl = $rootUrl."/co-".$CompanyName."/".$CompanyID."/products/".$rsUser[0]."/".$producttitleurl;
				$urlsetValue .= makeUrlTag ($pageUrl, $isoLastModifiedSite, "daily", "0.5");
			}	
		}
	}	
	header('Content-type: application/xml; charset="utf-8"',true);
	print "$xmlHeader	$urlsetOpen	$urlsetValue	$urlsetClose	";

?>