/**
  *
  *  Copyright 2005 www.AjaxLine.com - NaikonSoft 
  *  Author Igor Kononuchenko
  *
  *  Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
  *  file except in compliance with the License. You may obtain a copy of the License at
  *
  *         http://www.apache.org/licenses/LICENSE-2.0
  *
  *  Unless required by applicable law or agreed to in writing, software distributed under the
  *  License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
  *  either express or implied. See the License for the specific language governing permissions
  *  and limitations under the License.
  **/


var Rating = Class.create();
Rating.prototype = {
 initialize:function(container,options){
  this.container = $(container);
  this.options = options;
  this.setOptions();
  this.stars = new Array();
   this.onSendLabel =  document.createElement('text');
 this.onSendLabel.innerHTML = this.options.onSendText+'<BR>';
 this.onSendLabel.style.display = 'none';
   this.container.appendChild( this.onSendLabel);
  this.createStars();

   this.dispalyLabel = document.createElement('text');
    this.dispalyLabel.innerHTML = '<BR>'+this.displayText;
   this.container.appendChild(this.dispalyLabel);
  },
  setOptions:function(){
 
   this.urlToSend =   this.options.urlToSend; 
    this.overallRating = this.options.overallRating;
    this.displayText = this.options.displayText;
     this.afterVoteText=this.options.afterVoteText;
    this.starsCount = this.options.starsCount;
    this.hints = this.options.hints;
    this.value = this.options.value-1;
    this.id = this.options.id;
    this.emptyImageUrl = this.options.emptyImageUrl;
    this.hoverImageUrl = this.options.hoverImageUrl;
    this.votedImageUrl = this.options.votedImageUrl;
    this.votedHalfImageUrl = this.options.votedHalfImageUrl;
    this.afterYouVotedImageUrl = this.options.afterYouVotedImageUrl;
    this.afterYouVotedHalfImageUrl = this.options.afterYouVotedHalfImageUrl;
    this.isEnabled = this.options.isEnabled;
  },
 createStars:function(){  
  for(var i=0;i<this.starsCount;i++)
  {
    this.stars.push(new Star(this,i));
  } 
  this.setVoted(  this.value );
 },

notifyMouseOver:function(star){

 this.currentValue = star.index;
 this.setHover(true,star.index);
},
notifyMouseOut:function(star){
 
 this.currentValue = star.index;
 setTimeout(this.setUnHover.bind(this),300);

 if (this.currentValue!=star.index)  this.setHover(true,this.currentValue);

},
setUnHover:function(){
 this.setHover(false,this.starsCount-1);
    this.setVoted(  this.value );
},
notifyClick:function(star){

 this.setAfterYouVoted(star.index);
 this.isEnabled = false;
  this.onSendLabel.style.display = 'block';
  this.sendViaAjax(star.index+1);
},
sendViaAjax:function(value){ 
// debugger;
  		var pars = 'value=' + value+'&id='+this.id;	
		this.request = new Ajax.Request(
			this.urlToSend, 
			{
				method: 'get', 
				parameters: pars, 
				onComplete: this.onComplete.bind(this)
			});

},
  onComplete:function(originalRequest)
	{	
	      this.value = eval(originalRequest.responseText)-1;
	       if  (this.overallRating)
         this.overallRating.setAfterYouVoted(this.value);
         else 
         this.setAfterYouVoted(this.value);              
         setTimeout(this.sendTextClose.bind(this),300);
        
	},

  sendTextClose:function()
  {
       this.onSendLabel.style.display = 'none';
  },


setHover:function(isSetHover,index){
 for(var i=0;i<index+1;i++)
  {
    this.stars[i].setHover(isSetHover);
  } 
   },
  
  setVoted:function(index){
 for(var i=0;i<index+1;i++)
  {
    if (i -(index+1)>-1)  
    this.stars[i].setVoted(this.votedHalfImageUrl); else
    this.stars[i].setVoted(this.votedImageUrl);
  }
  },
  
  
    setAfterYouVoted:function(index){
     this.setHover(false,this.starsCount-1);
  for(var i=0;i<index+1;i++)
  {
         if (i -(index+1)>-1)  this.stars[i].setVoted(this.afterYouVotedHalfImageUrl); else
    this.stars[i].setVoted(this.afterYouVotedImageUrl);
  } 
    this.dispalyLabel.innerHTML = '<BR>'+this.afterVoteText+': '+(index+1);
}
 
};
var Star = Class.create();
Star.prototype = {
initialize:function(parent,index){
   this.container = parent.container;
   this.parent = parent;
   this.img =null;
   this.index =index; 
   this.CreateDOM();
},
 CreateDOM:function(){
  this.img = document.createElement('img');
  this.img.src =this.parent.emptyImageUrl; //this.parent.isEnabled?this.parent.emptyImageUrl:this.parent.emptyImageUrl;   
  this.parent.container.appendChild(this.img);
  if (this.parent.hints)
  this.img.title = this.parent.hints[this.index];
  this.img.onclick = this.onclick.bindAsEventListener(this);
  this.img.onmouseover = this.onmouseover.bindAsEventListener(this);
    this.img.onmouseout = this.onmouseout.bindAsEventListener(this);
 }, 
 setHover:function(isSetHover){
  this.img.src =!isSetHover?this.parent.emptyImageUrl:this.parent.hoverImageUrl; 
 },
  setVoted:function(url){
  this.setImage(url);
  this.isVoted = true;
 },
   setAfterYouVoted:function(){
  this.img.src =this.parent.afterYouVotedImageUrl; 
  this.isVoted = true;
 },
 setImage:function(url){
   this.img.src = url;
 },
 onmouseover:function(e){ 
 if (this.parent.isEnabled) 
 {
   this.img.style.cursor ='pointer';
   this.parent.notifyMouseOver(this);
 
 }
 },
 onmouseout:function(e){ 
  if (this.parent.isEnabled) 
 {

 
  this.img.style.cursor ='default'; 
 
  if(this.isNextElemStar(e))  
 this.parent.notifyMouseOut(this) 
 else
 {  
   if (this.isVoted) this.setVoted(this.getVotedImageUrl()); else
    this.img.src =this.parent.emptyImageUrl;   
   
   }
 }
 },
 getVotedImageUrl:function(){
  return (this.parent.value-(this.index)>-1&&this.parent.value-(this.index)<0)? this.parent.votedHalfImageUrl:this.parent.votedImageUrl;
 },
isNextElemStar:function(e){
  isIE = navigator.userAgent.toLowerCase().indexOf("ie")!= -1;
  if(isIE)
   return e.toElement.tagName!='IMG';
  else
  return e.relatedTarget.tagName!='IMG';
},
onclick:function(e){ 
  if (this.parent.isEnabled) 
   {
    this.img.style.cursor ='default'; 
   this.parent.notifyClick(this);
   }
 }


};