<?php
ob_start();


function loadEnv($filePath) {
    if (!file_exists($filePath)) {
        die("Error: .env file not found at $filePath");
    }

    $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) {
            continue; 
        }

        list($key, $value) = explode('=', $line, 2);
        $key = trim($key);
        $value = trim($value);

        // Store in $_ENV and $_SERVER
        $_ENV[$key] = $value;
        $_SERVER[$key] = $value;
    }
}

// Load environment variables
loadEnv(__DIR__ . '/../.env'); 

// Test Output
echo "Database Host: " . $_ENV['DB_HOST'] . "<br>";
echo "Database User: " . $_ENV['DB_USER'] . "<br>";
echo "Website Name: " . $_ENV['SITE_NAME'] . "<br>";







ini_set('display_errors', 0);
define('VERSION', '1.0.0');
define('PROTOCOL', $_SERVER['REQUEST_SCHEME'] . '://');

define('COOKIE_SALT', '12345!@#$%');
define('SITE_NAME', 'polymertubing');
define('SITE_DOMAIN', 'gatewayboatingclub.com');
define('SITE_ID', '1');
define('DOMAIN_NAME', 'gatewayboatingclub.com');
define('EMAILID', 'Gatewayboatingclub@gmail.com');
define('DEBUG_MODE', 0);
define('SENDMAIL_MODE', '0');

   
// for see error start
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// for see error end 
/*
-----------  
DB Settings
-----------
*/
  
if(DEBUG_MODE==0){
define('ROOT_DIR', 'C:/xampp/htdocs/management');
define('GLOBAL_INCLUDE_PATH', 'C:/xampp/htdocs/management/');
define('DOC_ROOT', PROTOCOL . 'localhost/management/');

define('DB_HOST', 'localhost');
define('DB_USER', 'polymert_usama2db');
define('DB_PASS', 'M2_oQ^b064p.');
define('DB_NAME', 'polymert_usama2_db');
define('DB_TYPE', 'mysql');
define('DB_PREFIX', '');

}else{
define('ROOT_DIR', '/home/polymert/public_html/Base-CRUD/');
// define( 'DOC_ROOT', PROTOCOL.'hardwarefair-india.com/');
define('DOC_ROOT', PROTOCOL . 'gatewayboatingclub.com/');

define('DB_HOST', 'localhost');
define('DB_USER', 'polymert_usama2db');
define('DB_PASS', 'M2_oQ^b064p.');
define('DB_NAME', 'polymert_usama2_db');
define('DB_TYPE', 'mysql');
define('DB_PREFIX', '');


}

define('REQUIRED_PATH', GLOBAL_INCLUDE_PATH . 'required/');
define('INCLUDE_PATH', GLOBAL_INCLUDE_PATH . 'include/');
define('AUTH_PATH', GLOBAL_INCLUDE_PATH . 'auth/');

define('CLASSES_PATH', INCLUDE_PATH . 'classes/');

define('VIEWS_PATH',GLOBAL_INCLUDE_PATH.'views/');


// -------------
// Mail settings 
// -------------

// text|html
define('MAIL_FORMAT', 'html');
//mail|sendmail|smtp  
define('MAIL_TYPE', 'mail');
define('SMTP_HOST', 'localhost');
define('SMTP_PORT', '25');
define('SMTP_AUTH', '0');
define('SMTP_USER', '');
define('SMTP_PASS', '');
define('SM_PATH', '/usr/sbin/sendmail');


define('MAIN_FOLDER', 'Base-CRUD/');

define('IMAGES_IMAGE_PATH', ROOT_DIR . 'uploadimg/images/');
define('IMAGES_IMAGE_THUMB_PATH', ROOT_DIR . 'uploadimg/images/thumb/');

define('IMAGES_PHOTO_PATH', DOC_ROOT . 'uploadimg/images/');
define('IMAGES_PHOTO_THUMB_PATH', DOC_ROOT . 'uploadimg/images/thumb/');


define('IMAGE_TEMP_PATH', GLOBAL_INCLUDE_PATH . 'temp/');
define('IMAGE_PHOTO_TEMP_PATH', DOC_ROOT . 'temp/');
define('IMAGE_DIR', DOC_ROOT . 'images/');
define('JS_DIR', DOC_ROOT . 'js/');
define('IMG_DIR', DOC_ROOT . 'images/');
define('CSS_DIR', DOC_ROOT . 'css/');

define('TEMP_DIR', DOC_ROOT . 'temp/');
define('TEMP_IMAGE_PATH', GLOBAL_INCLUDE_PATH . 'temp/');
define('TEST_IMAGE_PATH', ROOT_DIR . 'uploadimg/test/');
define('TEST_IMAGE_THUMB_PATH', ROOT_DIR . 'uploadimg/test/thumb/');
define('TEST_PHOTO_PATH', DOC_ROOT . 'uploadimg/test/');


define('DEFAULT_LANG', 'english');
